/*
 * Decompiled with CFR 0.152.
 */
package Dalzhim.swing;

import Dalzhim.swing.Highlight;
import Dalzhim.swing.SyntaxHighlightingDocument;
import java.awt.Color;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class DefaultSyntaxHighlightingDocument
extends DefaultStyledDocument
implements SyntaxHighlightingDocument {
    private Vector highlights = new Vector();
    private AttributeSet defaultTextStyle;

    public DefaultSyntaxHighlightingDocument() {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet, Color.black);
        this.setDefaultTextStyle(simpleAttributeSet);
    }

    public AttributeSet getDefaultTextStyle() {
        return this.defaultTextStyle;
    }

    public void setDefaultTextStyle(AttributeSet attributeSet) {
        this.defaultTextStyle = attributeSet;
    }

    public void addHighlight(Highlight highlight) {
        this.highlights.add(highlight);
    }

    public void insertHighlightedString(int n, String string) throws BadLocationException {
        Object[] objectArray;
        LinkedHashMap<Integer, AttributeSet> linkedHashMap = new LinkedHashMap<Integer, AttributeSet>();
        linkedHashMap.put(new Integer(0), this.getDefaultTextStyle());
        int n2 = 0;
        while (n2 < this.highlights.size()) {
            objectArray = (Object[])this.highlights.get(n2);
            Pattern pattern = objectArray.getPattern();
            Matcher matcher = pattern.matcher(string);
            int n3 = 0;
            while (matcher.find(n3)) {
                if (objectArray.getHighlightMode() == 0) {
                    linkedHashMap.put(new Integer(matcher.start()), objectArray.getHighlightStyle());
                    linkedHashMap.put(new Integer(matcher.end()), this.getDefaultTextStyle());
                } else if (objectArray.getHighlightMode() == 1) {
                    linkedHashMap.put(new Integer(matcher.start()), objectArray.getHighlightStyle());
                    linkedHashMap.put(new Integer(matcher.end()), objectArray.getSecondaryHighlightStyle());
                    if (string.indexOf(System.getProperty("line.separator")) != -1) {
                        linkedHashMap.put(new Integer(string.indexOf(System.getProperty("line.separator"), matcher.end())), this.getDefaultTextStyle());
                    }
                }
                n3 = matcher.end();
            }
            ++n2;
        }
        objectArray = linkedHashMap.keySet().toArray(new Integer[0]);
        Arrays.sort(objectArray);
        int n4 = 0;
        while (n4 < objectArray.length) {
            this.insertHighlightedString(n, string.substring((Integer)objectArray[n4], n4 + 1 < objectArray.length ? ((Integer)objectArray[n4 + 1]).intValue() : string.length()), (AttributeSet)linkedHashMap.get(objectArray[n4]));
            ++n4;
        }
    }

    public void insertHighlightedString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        super.insertString(this.getLength(), string, attributeSet);
    }
}

