/*
 * Decompiled with CFR 0.152.
 */
package Dalzhim.RemoteSphere;

import Dalzhim.RemoteSphere.ErrorWindow;
import Dalzhim.RemoteSphere.GUI;
import Dalzhim.RemoteSphere.InputReader;
import Dalzhim.RemoteSphere.LanguageFile;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.Socket;
import java.net.UnknownHostException;

public class SphereTelnetConnection {
    private static InputReader in;
    private static PrintStream out;
    private static Socket sphereSocket;

    public static void connect(String string, String string2) {
        try {
            sphereSocket = new Socket(string, Integer.parseInt(string2));
            in = new InputReader(sphereSocket.getInputStream());
            out = new PrintStream(sphereSocket.getOutputStream());
            out.print(" ");
            GUI.setConnected(true);
        }
        catch (UnknownHostException unknownHostException) {
            new ErrorWindow(GUI.window, LanguageFile.getString("ErrorConnectionFailed"));
        }
        catch (ConnectException connectException) {
            new ErrorWindow(GUI.window, LanguageFile.getString("ErrorConnectionFailed"));
        }
        catch (IOException iOException) {
            new ErrorWindow(GUI.window, LanguageFile.getString("ErrorConnectionFailed"));
        }
        catch (NumberFormatException numberFormatException) {
            new ErrorWindow(GUI.window, LanguageFile.getString("ErrorInvalidPort"));
        }
    }

    public static void close() {
        try {
            in.close();
            out.close();
            sphereSocket.close();
            GUI.setConnected(false);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void sendCommand(String string) {
        out.println(string);
        if (out.checkError()) {
            SphereTelnetConnection.close();
            new ErrorWindow(GUI.window, LanguageFile.getString("ErrorConnectionLost"));
        }
    }
}

