/*
 * Decompiled with CFR 0.152.
 */
package Dalzhim.RemoteSphere;

import Dalzhim.RemoteSphere.FileMethods;
import Dalzhim.swing.Highlight;
import Dalzhim.swing.JSyntaxHighlighter;
import java.awt.Color;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class SphereConsole
extends JSyntaxHighlighter {
    public SphereConsole() {
        this.setBackground(Color.black);
        this.loadSyntax();
    }

    public void loadSyntax() {
        String[] stringArray = FileMethods.getLines(new File("syntax.highlighting"));
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    Object object;
                    SimpleAttributeSet simpleAttributeSet;
                    Matcher matcher = Pattern.compile("(.+?) <<->> (.+?)(?: <<->> (.+))?").matcher(stringArray[i]);
                    if (matcher.matches()) {
                        simpleAttributeSet = new SimpleAttributeSet();
                        object = new SimpleAttributeSet();
                        String string = matcher.group(1);
                        String string2 = matcher.group(2);
                        this.setAttributes(simpleAttributeSet, string2);
                        if (matcher.group(3) != null) {
                            String string3 = matcher.group(3);
                            this.setAttributes((SimpleAttributeSet)object, string3);
                            this.getSyntaxHighlightingDocument().addHighlight(new Highlight(string, simpleAttributeSet, (AttributeSet)object));
                            continue;
                        }
                        this.getSyntaxHighlightingDocument().addHighlight(new Highlight(string, simpleAttributeSet));
                        continue;
                    }
                    matcher = Pattern.compile("<<->> (.+?) <<->>").matcher(stringArray[i]);
                    if (!matcher.matches()) continue;
                    simpleAttributeSet = new SimpleAttributeSet();
                    object = matcher.group(1);
                    this.setAttributes(simpleAttributeSet, (String)object);
                    this.getSyntaxHighlightingDocument().setDefaultTextStyle(simpleAttributeSet);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    private void setAttributes(SimpleAttributeSet simpleAttributeSet, String string) {
        Matcher matcher = Pattern.compile("<([.[^>]]+)>").matcher(string);
        while (matcher.find()) {
            try {
                String string2 = matcher.group(1);
                if (string2.indexOf("fgcolor=") == 0) {
                    StyleConstants.setForeground(simpleAttributeSet, new Color(Integer.parseInt(string2.substring(8, 10), 16), Integer.parseInt(string2.substring(10, 12), 16), Integer.parseInt(string2.substring(12, 14), 16)));
                    continue;
                }
                if (string2.indexOf("bgcolor=") == 0) {
                    StyleConstants.setBackground(simpleAttributeSet, new Color(Integer.parseInt(string2.substring(8, 10), 16), Integer.parseInt(string2.substring(10, 12), 16), Integer.parseInt(string2.substring(12, 14), 16)));
                    continue;
                }
                if (string2.indexOf("bold") == 0) {
                    StyleConstants.setBold(simpleAttributeSet, true);
                    continue;
                }
                if (string2.indexOf("italic") == 0) {
                    StyleConstants.setItalic(simpleAttributeSet, true);
                    continue;
                }
                if (string2.indexOf("underline") == 0) {
                    StyleConstants.setUnderline(simpleAttributeSet, true);
                    continue;
                }
                if (string2.indexOf("strike") == 0) {
                    StyleConstants.setStrikeThrough(simpleAttributeSet, true);
                    continue;
                }
                if (string2.indexOf("font=") == 0) {
                    StyleConstants.setFontFamily(simpleAttributeSet, string2.substring(5, string2.length()));
                    continue;
                }
                if (string2.indexOf("size=") == 0) {
                    StyleConstants.setFontSize(simpleAttributeSet, Integer.parseInt(string2.substring(5, string2.length())));
                    continue;
                }
                if (string2.indexOf("subscript") == 0) {
                    StyleConstants.setSubscript(simpleAttributeSet, true);
                    continue;
                }
                if (string2.indexOf("superscript") != 0) continue;
                StyleConstants.setSuperscript(simpleAttributeSet, true);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

