/*
 * Decompiled with CFR 0.152.
 */
package Dalzhim.RemoteSphere;

import Dalzhim.RemoteSphere.LanguageFile;
import Dalzhim.RemoteSphere.Settings;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class OptionsWindow {
    JButton apply;
    JButton cancel;
    JButton okay;
    JComboBox languages;
    JDialog window;
    JRadioButton logging_disabled;
    JRadioButton logging_enabled;
    JRadioButton logFilesSwitch_never;
    JRadioButton logFilesSwitch_daily;
    JTextField languageFolder;
    JTextField logFolder;

    public OptionsWindow(JFrame jFrame) {
        this.window = new JDialog(jFrame, LanguageFile.getString("OptionsWindowTitle"), true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 1, 0, 0));
        jPanel.setMaximumSize(new Dimension(400, 300));
        this.window.setContentPane(jPanel);
        this.window.setResizable(false);
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout);
        JTabbedPane jTabbedPane = new JTabbedPane();
        JPanel jPanel3 = new JPanel();
        this.setupTabbedPane(jTabbedPane);
        this.setupButtonsPane(jPanel3);
        gridBagLayout.setConstraints(jTabbedPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        gridBagLayout.setConstraints(jPanel3, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 15, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel2.add(jTabbedPane);
        jPanel2.add(jPanel3);
        jPanel.add(new JScrollPane(jPanel2));
        this.initValues();
        this.window.pack();
        this.window.setLocation(jFrame.getWidth() / 2 - this.window.getWidth() / 2, jFrame.getHeight() / 2 - this.window.getHeight() / 2);
        this.window.setVisible(true);
    }

    public void setupTabbedPane(JTabbedPane jTabbedPane) {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        this.setupGeneralPane(jPanel);
        this.setupLogsPane(jPanel2);
        jTabbedPane.addTab(LanguageFile.getString("TabGeneral"), jPanel);
        jTabbedPane.addTab(LanguageFile.getString("TabLogs"), jPanel2);
    }

    public void setupGeneralPane(JPanel jPanel) {
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        this.setupLanguagePane(jPanel2);
        this.setupLanguageFolderPane(jPanel3);
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
    }

    public void setupLanguagePane(JPanel jPanel) {
        jPanel.setLayout(new GridLayout(1, 1, 0, 0));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), LanguageFile.getString("LanguageBorder")));
        JPanel jPanel2 = new JPanel();
        this.languages = new JComboBox<String>(this.listLanguageFiles());
        jPanel2.add(this.languages);
        jPanel.add(jPanel2);
    }

    public void setupLanguageFolderPane(JPanel jPanel) {
        jPanel.setLayout(new GridLayout(1, 1, 0, 0));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), LanguageFile.getString("LanguageFolderBorder")));
        JPanel jPanel2 = new JPanel();
        this.languageFolder = new JTextField(15);
        jPanel2.add(this.languageFolder);
        jPanel.add(jPanel2);
    }

    public void setupLogsPane(JPanel jPanel) {
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        this.setupLoggingPane(jPanel2);
        this.setupLogFileSwitchPane(jPanel3);
        this.setupLogFolderPane(jPanel4);
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        jPanel.add(jPanel4);
    }

    public void setupLoggingPane(JPanel jPanel) {
        jPanel.setLayout(new GridLayout(1, 1, 0, 0));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), LanguageFile.getString("LoggingBorder")));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        this.logging_disabled = new JRadioButton(LanguageFile.getString("ButtonDisabled"));
        this.logging_enabled = new JRadioButton(LanguageFile.getString("ButtonEnabled"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.logging_disabled);
        buttonGroup.add(this.logging_enabled);
        jPanel2.add(this.logging_disabled);
        jPanel2.add(this.logging_enabled);
        jPanel.add(jPanel2);
    }

    public void setupLogFileSwitchPane(JPanel jPanel) {
        jPanel.setLayout(new GridLayout(1, 1, 0, 0));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), LanguageFile.getString("LogFilesSwitchBorder")));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        this.logFilesSwitch_never = new JRadioButton(LanguageFile.getString("ButtonNever"));
        this.logFilesSwitch_daily = new JRadioButton(LanguageFile.getString("ButtonDaily"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.logFilesSwitch_never);
        buttonGroup.add(this.logFilesSwitch_daily);
        jPanel2.add(this.logFilesSwitch_never);
        jPanel2.add(this.logFilesSwitch_daily);
        jPanel.add(jPanel2);
    }

    public void setupLogFolderPane(JPanel jPanel) {
        jPanel.setLayout(new GridLayout(1, 1, 0, 0));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), LanguageFile.getString("LogFolderBorder")));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        this.logFolder = new JTextField(15);
        jPanel2.add(this.logFolder);
        jPanel.add(jPanel2);
    }

    public void setupButtonsPane(JPanel jPanel) {
        this.apply = new JButton(LanguageFile.getString("ButtonApply"));
        this.cancel = new JButton(LanguageFile.getString("ButtonCancel"));
        this.okay = new JButton(LanguageFile.getString("ButtonOkay"));
        this.apply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OptionsWindow.this.apply();
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OptionsWindow.this.cancel();
            }
        });
        this.okay.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OptionsWindow.this.okay();
            }
        });
        jPanel.add(this.okay);
        jPanel.add(this.cancel);
        jPanel.add(this.apply);
    }

    public void initValues() {
        String string = Settings.getSetting("Logging");
        String string2 = Settings.getSetting("Log Files Switch");
        String string3 = Settings.getSetting("Log Folder");
        String string4 = Settings.getSetting("Language");
        String string5 = Settings.getSetting("Language Folder");
        if (string.equals("disabled")) {
            this.logging_disabled.setSelected(true);
        } else if (string.equals("enabled")) {
            this.logging_enabled.setSelected(true);
        }
        if (string2.equals("never")) {
            this.logFilesSwitch_never.setSelected(true);
        } else if (string2.equals("daily")) {
            this.logFilesSwitch_daily.setSelected(true);
        }
        this.logFolder.setText(string3);
        this.languages.setSelectedItem(string4);
        this.languageFolder.setText(string5);
    }

    public void applySettings() {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        if (this.logging_disabled.isSelected()) {
            string = "disabled";
        } else if (this.logging_enabled.isSelected()) {
            string = "enabled";
        }
        if (this.logFilesSwitch_never.isSelected()) {
            string2 = "never";
        } else if (this.logFilesSwitch_daily.isSelected()) {
            string2 = "daily";
        }
        string3 = this.logFolder.getText();
        string4 = (String)this.languages.getSelectedItem();
        string5 = this.languageFolder.getText();
        Settings.setSetting("Logging", string);
        Settings.setSetting("Log Files Switch", string2);
        Settings.setSetting("Log Folder", string3);
        Settings.setSetting("Language", string4);
        Settings.setSetting("Language Folder", string5);
    }

    public void apply() {
        this.applySettings();
    }

    public void cancel() {
        this.window.dispose();
    }

    public void okay() {
        this.applySettings();
        this.window.dispose();
    }

    public String[] listLanguageFiles() {
        String[] stringArray = new File(Settings.getSetting("Language Folder").equals("") ? "./" : Settings.getSetting("Language Folder")).list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.indexOf(".properties") != -1;
            }
        });
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].substring(0, stringArray[i].length() - 11);
        }
        return stringArray;
    }
}

