/*
 * Decompiled with CFR 0.152.
 */
package Dalzhim.RemoteSphere;

import Dalzhim.RemoteSphere.AboutWindow;
import Dalzhim.RemoteSphere.ConnectWindow;
import Dalzhim.RemoteSphere.LanguageFile;
import Dalzhim.RemoteSphere.Logger;
import Dalzhim.RemoteSphere.OptionsWindow;
import Dalzhim.RemoteSphere.RemoteSphere;
import Dalzhim.RemoteSphere.SphereConsole;
import Dalzhim.RemoteSphere.SphereTelnetConnection;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;

public class GUI {
    private static JMenuItem connect;
    private static JMenuItem disconnect;
    private static JScrollPane scroll;
    private static JTextField input;
    private static SphereConsole log;
    public static boolean connected;
    public static final int screenHeight;
    public static final int screenWidth;
    public static JFrame window;
    public static String newline;

    public static void load() {
        window = new JFrame("Remote Sphere");
        window.addWindowListener(new WL());
        window.setDefaultCloseOperation(0);
        GUI.setupMenuBar();
        GUI.setupGUI();
        window.pack();
        window.setVisible(true);
    }

    public static void setupMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu(LanguageFile.getString("MenuFile"));
        JMenu jMenu2 = new JMenu(LanguageFile.getString("MenuEnd"));
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        connect = jMenu.add(new ConnectAction());
        disconnect = jMenu.add(new DisconnectAction());
        jMenu.add(new OptionsAction());
        jMenu.add(new QuitAction());
        jMenu2.add(new AboutAction());
        disconnect.setEnabled(false);
        window.setJMenuBar(jMenuBar);
    }

    public static void setupGUI() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(LanguageFile.getString("ConsoleWindowBorder")));
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        window.setContentPane(jPanel);
        log = new SphereConsole();
        scroll = new JScrollPane(log);
        input = new JTextField();
        input.addActionListener(new AL());
        input.setEditable(false);
        scroll.setPreferredSize(new Dimension(500, 400));
        gridBagLayout.setConstraints(scroll, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        gridBagLayout.setConstraints(input, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 15, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add(scroll);
        jPanel.add(input);
    }

    public static void showText(String string) {
        try {
            log.getSyntaxHighlightingDocument().insertHighlightedString(log.getDocument().getLength(), string);
            log.setCaretPosition(log.getSyntaxHighlightingDocument().getLength());
            Logger.write(string);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public static void eraseCharacter() {
        try {
            log.getSyntaxHighlightingDocument().remove(log.getSyntaxHighlightingDocument().getLength() - 1, 1);
            Logger.erase(1);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public static void setConnected(boolean bl) {
        connect.setEnabled(!bl);
        disconnect.setEnabled(bl);
        input.setEditable(bl);
        connected = bl;
    }

    static {
        connected = false;
        screenHeight = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        screenWidth = (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        newline = System.getProperty("line.separator");
    }

    static class WL
    extends WindowAdapter {
        WL() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            RemoteSphere.performExitProcedure();
        }
    }

    static class AL
    implements ActionListener {
        AL() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SphereTelnetConnection.sendCommand(input.getText());
            input.setText("");
        }
    }

    static class AboutAction
    extends AbstractAction {
        public AboutAction() {
            super(LanguageFile.getString("MenuItemAbout"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            new AboutWindow(window);
        }
    }

    static class OptionsAction
    extends AbstractAction {
        public OptionsAction() {
            super(LanguageFile.getString("MenuItemOptions"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            new OptionsWindow(window);
        }
    }

    static class QuitAction
    extends AbstractAction {
        public QuitAction() {
            super(LanguageFile.getString("MenuItemQuit"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RemoteSphere.performExitProcedure();
        }
    }

    static class DisconnectAction
    extends AbstractAction {
        public DisconnectAction() {
            super(LanguageFile.getString("MenuItemDisconnect"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SphereTelnetConnection.close();
        }
    }

    static class ConnectAction
    extends AbstractAction {
        public ConnectAction() {
            super(LanguageFile.getString("MenuItemConnect"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            new ConnectWindow(window);
        }
    }
}

