/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AWTException;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Robot;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class KMServer {
    private boolean listen = true;
    private boolean reading;
    private InetSocketAddress addr = new InetSocketAddress(5197);
    private KMInput in;
    private KMOutput out;
    private ServerSocket server;
    private Socket client;
    public static String user;
    public static String pass;

    public static void main(String[] stringArray) {
        KMServer.initAuth();
        new KMServer();
    }

    public static void initAuth() {
        File file = new File("auth.cfg");
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            user = bufferedReader.readLine();
            pass = bufferedReader.readLine();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Couldn't init auth information");
            System.exit(-1);
        }
        catch (IOException iOException) {
            System.out.println("Couldn't init auth information");
            System.exit(-1);
        }
    }

    public KMServer() {
        while (this.listen) {
            try {
                this.server = new ServerSocket();
                this.server.bind(this.addr);
                this.client = this.server.accept();
                GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
                Robot robot = new Robot(graphicsDevice);
                this.out = new KMOutput(this.client.getOutputStream(), robot, graphicsDevice.getDefaultConfiguration().getBounds());
                this.in = new KMInput(this.client.getInputStream(), robot);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (AWTException aWTException) {
                aWTException.printStackTrace();
            }
            try {
                this.out.disconnect();
                this.client.close();
                this.server.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

