/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AWTException;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageOutputStream;

public class KMOutput
implements Runnable {
    private boolean running;
    private ImageOutputStream out;
    private OutputStream o;
    private Rectangle bounds;
    private Robot comp;
    private Thread thisThread;

    public KMOutput(OutputStream outputStream, Robot robot, Rectangle rectangle) throws IOException, AWTException {
        this.o = outputStream;
        this.out = ImageIO.createImageOutputStream(this.o);
        this.running = true;
        this.comp = robot;
        this.bounds = rectangle;
        this.thisThread = new Thread(this);
        this.thisThread.start();
    }

    public void run() {
        while (this.running) {
            try {
                BufferedImage bufferedImage = this.comp.createScreenCapture(this.bounds);
                System.out.println(ImageIO.write((RenderedImage)bufferedImage, "jpeg", this.out));
                Thread.sleep(50L);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        System.out.println("Out of loop");
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void disconnect() {
        this.running = false;
    }
}

