/*
 * Decompiled with CFR 0.152.
 */
import java.awt.GridLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.swing.JFrame;

public class KMClient {
    private KMOutput out;
    private KMInput in;
    private RemoteDesktop remoteDesktop;
    private Socket sock;
    private static String host;
    public static String pass;
    public static String user;

    public static void main(String[] stringArray) {
        try {
            KMClient.initHost();
            new KMClient();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("The host address couldn't be read.");
            System.exit(-1);
        }
        catch (IOException iOException) {
            System.out.println("The host address couldn't be read.");
            System.exit(-1);
        }
    }

    public static void initHost() throws FileNotFoundException, IOException {
        File file = new File("host.cfg");
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        host = bufferedReader.readLine();
        user = bufferedReader.readLine();
        pass = bufferedReader.readLine();
    }

    public KMClient() {
        try {
            this.sock = new Socket();
            this.sock.connect(new InetSocketAddress(host, 5197));
            this.remoteDesktop = new RemoteDesktop();
            this.out = new KMOutput(this.sock.getOutputStream());
            this.in = new KMInput(this.sock.getInputStream(), this.remoteDesktop);
            JFrame jFrame = new JFrame();
            jFrame.getContentPane().setLayout(new GridLayout(1, 1, 0, 0));
            jFrame.getContentPane().add(this.remoteDesktop);
            jFrame.pack();
            jFrame.setLocation(0, 0);
            jFrame.setSize(1024, 768);
            jFrame.setVisible(true);
            this.remoteDesktop.addKeyListener(new KL());
            this.remoteDesktop.addMouseListener(new ML());
            this.remoteDesktop.addMouseMotionListener(new MML());
            jFrame.addWindowListener(new WL());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void disconnect() {
        try {
            this.in.disconnect();
            this.out.disconnect();
            this.sock.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.exit(0);
    }

    class WL
    extends WindowAdapter {
        WL() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            KMClient.this.disconnect();
        }
    }

    class MML
    extends MouseMotionAdapter {
        MML() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            try {
                CustomEvent customEvent = new CustomEvent();
                customEvent.setType(4);
                customEvent.setValue(mouseEvent.getX() + ";" + mouseEvent.getY());
                KMClient.this.out.sendEvent(customEvent);
            }
            catch (IOException iOException) {
                KMClient.this.disconnect();
            }
        }
    }

    class ML
    extends MouseAdapter {
        ML() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            try {
                CustomEvent customEvent = new CustomEvent();
                customEvent.setType(2);
                String string = mouseEvent.getButton() == 1 ? "1" : (mouseEvent.getButton() == 2 ? "2" : "3");
                customEvent.setValue(string);
                KMClient.this.out.sendEvent(customEvent);
            }
            catch (IOException iOException) {
                KMClient.this.disconnect();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            try {
                CustomEvent customEvent = new CustomEvent();
                customEvent.setType(3);
                String string = mouseEvent.getButton() == 1 ? "1" : (mouseEvent.getButton() == 2 ? "2" : "3");
                customEvent.setValue(string);
                KMClient.this.out.sendEvent(customEvent);
            }
            catch (IOException iOException) {
                KMClient.this.disconnect();
            }
        }
    }

    class KL
    extends KeyAdapter {
        KL() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            try {
                CustomEvent customEvent = new CustomEvent();
                customEvent.setType(0);
                customEvent.setValue(String.valueOf(keyEvent.getKeyCode()));
                KMClient.this.out.sendEvent(customEvent);
            }
            catch (IOException iOException) {
                KMClient.this.disconnect();
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            try {
                CustomEvent customEvent = new CustomEvent();
                customEvent.setType(1);
                customEvent.setValue(String.valueOf(keyEvent.getKeyCode()));
                KMClient.this.out.sendEvent(customEvent);
            }
            catch (IOException iOException) {
                KMClient.this.disconnect();
            }
        }
    }
}

